/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.gitlab.jfronny.commons.ref.R;
import io.gitlab.jfronny.libjf.Flags;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.coprocess.CoProcess;
import io.gitlab.jfronny.libjf.web.api.v1.WebServer;
import io.gitlab.jfronny.libjf.web.impl.JfWebConfig;
import io.gitlab.jfronny.libjf.web.impl.host.RequestHandler;
import io.gitlab.jfronny.libjf.web.impl.variant.hosted.HostedWebServer;
import io.gitlab.jfronny.libjf.web.impl.variant.shared.SharedWebServer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

public class JfWeb
implements CoProcess,
ModInitializer {
    private static final RequestHandler handler;
    public static final WebServer SERVER;

    @ApiStatus.Internal
    public static RequestHandler getHandler() {
        return handler;
    }

    public void start() {
        if (this.isEnabled()) {
            SERVER.queueRestart(R::nop);
        }
    }

    public void stop() {
        if (!(SERVER instanceof SharedWebServer)) {
            SERVER.stop();
        }
    }

    public void onInitialize() {
        if (this.isEnabled()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"libjf").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"web").requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(context -> {
                if (SERVER.isActive()) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"LibWeb is active. Use libweb restart to reload"), false);
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"LibWeb is not active. Use libweb restart to reload"), false);
                }
                return 1;
            })).then(class_2170.method_9247((String)"restart").executes(context -> {
                try {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Restarting LibWeb"), true);
                    SERVER.queueRestart(() -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"LibWeb restarted"), true));
                }
                catch (Exception e) {
                    LibJf.LOGGER.error("Failed to run restart command", (Throwable)e);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
                }
                return 1;
            })))));
        }
    }

    private boolean isEnabled() {
        return JfWebConfig.enableFileHost | Flags.getBoolFlag((String)"web").value();
    }

    static {
        JfWebConfig.ensureValidPort();
        handler = new RequestHandler();
        SERVER = JfWebConfig.port != -1 ? new HostedWebServer(handler, JfWebConfig.port, JfWebConfig.maxConnections) : (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? new HostedWebServer(handler, 0, JfWebConfig.maxConnections) : new SharedWebServer(handler));
    }
}

